/*
	On-memory ShiftJIS / EUC Converter
*/

/* first byte of EUC char? */
#define is_euc1(c) (0xa1 <= (c) && (c) <= 0xfe)

/* second byte of EUC char? */
#define is_euc2(c) is_euc1(c)

/* first byte of SJIS char? */
#define is_sjis1(c) (0x81 <= (c) && (c) <= 0x9f || 0xe0 <= (c) && (c) <= 0xfc)

/* second byte of SJIS char? */
#define is_sjis2(c) (0x40 <= (c) && (c) <= 0x7e || 0x80 <= (c) && (c) <= 0xfc)

/* 1byte Kana char? */
#define is_kana(c) (0xa0 <= (c) && (c) <= 0xdf)

/* convert ShiftJIS char into EUC char */
static unsigned short sjis2euc(unsigned short c)
{
    unsigned short c2;

    c2 = c & 0xff;
    if (c2 > 0x7e) --c2;
    c2 -= 0x40;
    c >>= 8;
    if (c > 0x9f) c -= 0x40;
    c = (c - 0x81) * 2;
    if (c2 >= 0x5e) {
	c2 -= 0x5e;
	++c;
    }
    return  (c << 8) + c2 + 0xa1a1;
}

/* convert EUC char into ShiftJIS char */
static unsigned short euc2sjis(unsigned short c)
{
    unsigned short c2;

    c -= 0xa1a1;
    c2 = c & 0xff;
    if (c & 0x100)  c2 += 0x5e;
    c  >>= 9;
    if ((c += 0x81) > 0x9f)
	c += 0x40;
    if ((c2 += 0x40) > 0x7e)
	++c2;
    return  (c << 8) + c2;
}

/* convert from EUC into ShiftJIS */
/* siz < 0 specifies C-string (terminated by 0) */
void memjcnv_euc2sjis(char *mem, int siz)
{
    unsigned char *s = (unsigned char *)mem;
    unsigned char *d = (unsigned char *)mem;
    unsigned short c1;
    int len = siz;

    if (len < 0) len = 0x7fffffff;
    while ((c1 = *s++) != 0 && len-- > 0) {
	unsigned short c2 = *s;
	if (is_euc1(c1) && is_euc2(c2) && len > 0) {
	    unsigned short cc = euc2sjis((c1 << 8) + c2);
	    *d++ = cc >> 8;
	    *d++ = cc & 0xff;
	    s++;
	    len--;
	} else {
	    d++;
	}
    }
}


/* convert from ShiftJIS into EUC */
/* siz < 0 specifies C-string (terminated by 0) */
void memjcnv_sjis2euc(char *mem, int siz)
{
    unsigned char *s = (unsigned char *)mem;
    unsigned char *d = (unsigned char *)mem;
    unsigned short c1;
    int len = siz;

    if (len < 0) len = 0x7fffffff;
    while ((c1 = *s++) != 0 && len-- > 0) {
	unsigned short c2 = *s;
	if (is_sjis1(c1) && is_sjis2(c2) && len > 0) {
	    unsigned short cc = sjis2euc((c1 << 8) + c2);
	    *d++ = cc >> 8;
	    *d++ = cc & 0xff;
	    s++;
	    len--;
	} else if (is_kana(c1)) {
	    /* convert 1byte kana into '#' */
	    *d++ = '#';
	} else {
	    d++;
	}
    }
}

